/*____________________________________________________________________________
	Copyright (C) 2000 Networks Associates Technology, Inc.
	All rights reserved.
	
	$Id: main.c,v 1.21.4.1 2001/05/21 21:32:49 ajivsov Exp $
____________________________________________________________________________*/
#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <process.h>
#include <tchar.h>
#include "pgpRPCMsg.h"

#include "service.h"

#define SZSERVICENAME	"PGPsdkServ"

SERVICE_STATUS_HANDLE   sshStatusHandle;
BOOL                    bDebug = FALSE;
BOOL WINAPI				ControlHandler ( DWORD dwCtrlType );
static DWORD			g_platformID;
static SERVICE_STATUS	Status;

typedef int (CALLBACK *REGPROC)(DWORD,DWORD);
void pgpRPCThread(void *);

#if PGP_DEBUG
static PGPBoolean sDebugLogMsgs = 0;

void
DbgPrintf(char *mesg, ...)
{
	va_list ap;
	va_start(ap, mesg);

	if (bDebug) {
		int chars_written;
		char buf[1024], buf2[1024];
		char namebuf[80];
		int namebuflen = sizeof(namebuf);
		if (GetUserName(namebuf, &namebuflen) == 0)
			strcpy(namebuf, "???");
		vsprintf(buf, mesg, ap);
		sprintf(buf2, "%s %s\n", namebuf, buf);
		WriteConsole(GetStdHandle(STD_OUTPUT_HANDLE), buf2, strlen(buf2),
			&chars_written, NULL);
	}

	if (sDebugLogMsgs) {
		time_t x = time(0);
		char namebuf[80];
		int namebuflen = sizeof(namebuf);
		FILE *fp = fopen("C:\\temp\\PGPsdkServ.txt", "a");
		if (fp) {
			if (GetUserName(namebuf, &namebuflen) == 0)
				strcpy(namebuf, "???");
			fprintf(fp, "%.19s %-10s ", ctime(&x), namebuf);
			vfprintf(fp, mesg, ap);
			fprintf(fp, "\n");
			fclose(fp);
		}
	}
	va_end(ap);
}
#else
void DbgPrintf(char *mesg, ...) { }
#endif

void
SetStatus(DWORD dwState)
{
	Status.dwCurrentState = dwState;
	SetServiceStatus(sshStatusHandle, &Status);
}

static HANDLE hEventSource = NULL;

void
LogEvent(LPTSTR lpszMsg)
{
    LPTSTR lpszStrings[5];

#if PGP_DEBUG
	DbgPrintf(lpszMsg);
#endif

	if (g_platformID == VER_PLATFORM_WIN32_NT) {
		if (!hEventSource)
			hEventSource = RegisterEventSource(NULL, TEXT(SZSERVICENAME));
		lpszStrings[0] = lpszMsg;

		if (hEventSource) {
			ReportEvent(hEventSource, // handle of event source
				EVENTLOG_ERROR_TYPE,  // event type
				0,                    // event category
				0,                    // event ID
				NULL,                 // current user's SID
				1,                    // strings in lpszStrings
				0,                    // no bytes of raw data
				lpszStrings,          // array of error strings
				NULL);                // no raw data
		}
	}
}

void
LogTypeEvent(int evtype, LPTSTR lpszMsg)
{
    LPTSTR lpszStrings[5];

	if (g_platformID == VER_PLATFORM_WIN32_NT) {
		if (!hEventSource)
			hEventSource = RegisterEventSource(NULL, TEXT(SZSERVICENAME));
		lpszStrings[0] = lpszMsg;

		if (hEventSource) {
			ReportEvent(hEventSource, // handle of event source
				(WORD)evtype,				  // event type
				0,                    // event category
				0,                    // event ID
				NULL,                 // current user's SID
				1,                    // strings in lpszStrings
				0,                    // no bytes of raw data
				lpszStrings,          // array of error strings
				NULL);                // no raw data
		}
	}
}

static VOID WINAPI
sServiceCtrl(DWORD dwCtrlCode)
{
    switch(dwCtrlCode){
    case SERVICE_CONTROL_STOP:
		DbgPrintf("sServiceCtrl(SERVICE_CONTROL_STOP)\n");
        SetStatus(SERVICE_STOP_PENDING);
        pgpRPCServiceStop();
        return;
    case SERVICE_CONTROL_INTERROGATE:
		DbgPrintf("sServiceCtrl(SERVICE_CONTROL_INTERROGATE)\n");
        break;
    default:	// Invalid Control Code
        break;
    }
    SetStatus(Status.dwCurrentState);
}

static int
sCtrlHandler(DWORD ctrltype) 
{
    switch (ctrltype) { 
	case CTRL_LOGOFF_EVENT:
		DbgPrintf("CtrlHandler(CTRL_LOGOFF_EVENT)\n");
		return FALSE;
    case CTRL_SHUTDOWN_EVENT:
		DbgPrintf("CtrlHandler(CTRL_SHUTDOWN_EVENT)\n");
		return FALSE;
    default:
        return FALSE; 
    } 
} 

static void
sMakeArgv(int *argcptr, char ***argvptr)
{
	static char commandLine[80];
	static char *argv[128];
	char *c;
	int argc = 0;

	strcpy(commandLine, GetCommandLine());
	c = commandLine;
	while(*c) {
		if(*c == '"') {
			if(*++c)
				argv[argc++] = c;
			while(*c && *c != '"')
				c++;
			if(*c)
				*c++ = 0;
		}
		else {
			argv[argc++] = c;
			while(*c && *c != ' ' && *c != '\t')
				c++;
		}
		if(*c) {
			*c = 0;
			c++;
		}
		while(*c && (*c == ' ' || *c == '\t'))
			c++;
	}
	argv[argc] = NULL;
	*argvptr = argv;
	*argcptr = argc;
}

static int
sServiceInitialize()
{
	DbgPrintf("sServiceInitialize()");

	if (g_platformID == VER_PLATFORM_WIN32_WINDOWS) {
		// Call RegisterServiceProcess
		HMODULE hnd;
		REGPROC fproc;
		int err;
		
		hnd = LoadLibrary("kernel32.dll");
		if (!hnd) {
			printf("Unable to register service: no handle to kernel32");
			return FALSE;
		}
		
		fproc = (REGPROC) GetProcAddress(hnd, "RegisterServiceProcess");
		if (!fproc) {
			printf(
				"Unable to register service: "
				"RegisterServiceProcess not found");
			return FALSE;
		}
		
		err = (*fproc)(0, 1);
		
		if (!err) {
			printf(
				"Unable to register service: "
				"RegisterServiceProcess failed");
			return FALSE;
		}
		(void) FreeLibrary(hnd);

		return TRUE;
	} else if (g_platformID == VER_PLATFORM_WIN32_NT) {
		Status.dwServiceType = SERVICE_WIN32_OWN_PROCESS| SERVICE_INTERACTIVE_PROCESS;
		Status.dwCurrentState = SERVICE_STOPPED;
		Status.dwControlsAccepted = SERVICE_ACCEPT_STOP | SERVICE_ACCEPT_SHUTDOWN;
		Status.dwWin32ExitCode = 0;
		Status.dwServiceSpecificExitCode = 0;
		Status.dwCheckPoint = 0;
		Status.dwWaitHint = 0;

		SetStatus(SERVICE_START_PENDING);
		return TRUE;
	}

	return FALSE;
}

void
sServiceMain(DWORD dwArgc, LPTSTR* lpszArgv)
{
	DbgPrintf("sServiceMain()");

	if (g_platformID == VER_PLATFORM_WIN32_NT) {
		if (!bDebug) {
			sshStatusHandle = RegisterServiceCtrlHandler(TEXT(SZSERVICENAME), sServiceCtrl );
			DbgPrintf("sshStatusHandle = 0x%x", sshStatusHandle);
		}
	}

	if (sServiceInitialize())
		pgpRPCServiceRun();

	DbgPrintf("sServiceMain(): pgpRPCServiceRun() returns\n");

	if (g_platformID == VER_PLATFORM_WIN32_NT)
		SetStatus(SERVICE_STOPPED);

	pgpRPCServerShuttingDown();
}

int
sServiceStart()
{
	if (g_platformID == VER_PLATFORM_WIN32_WINDOWS) {
		sServiceMain(0,0);
		return TRUE;
	}
	else if (g_platformID == VER_PLATFORM_WIN32_NT) {
		int b;
		SERVICE_TABLE_ENTRY dispatchTable[] = {
			{ TEXT(SZSERVICENAME), (LPSERVICE_MAIN_FUNCTION)sServiceMain },
			{ NULL, NULL }
		};
		DbgPrintf("Calling StartServiceCtrlDispatcher...");
		b = StartServiceCtrlDispatcher(dispatchTable);
		DbgPrintf("  StartServiceCtrlDispatcher() returns %d", b);
		return b;
	}
	return FALSE;
}



int WINAPI 
WinMain(HINSTANCE hI, HINSTANCE hP, LPSTR lpCL, int nCS)
{
	OSVERSIONINFO vinfo;
	int argc;
	char **argv;

	sMakeArgv(&argc, &argv);

	while (*++argv) {
		if (!strcmp(*argv, "-debug"))
			bDebug = 1;
	}

	vinfo.dwOSVersionInfoSize = sizeof(vinfo);
	if (!GetVersionEx(&vinfo))
		exit(1);
	g_platformID = vinfo.dwPlatformId;

	pgpRPCCreateBEContext();

	_beginthread(pgpRPCThread, 0, NULL);

    if (bDebug) {
		if (AllocConsole() == 0) {
			printf("AllocConsole() fails");
			exit(1);
		}
		SetConsoleTitle("PGPsdkServ Console");
		DbgPrintf("PGPsdkServ running in debug mode.\n");
		sServiceMain(0, 0);
	}
	else {
		DbgPrintf("");
		DbgPrintf("Calling sServiceStart().");
		sServiceStart();
	}
}
